<?php

namespace Hilco\Models;

/**
 * @property string $inventory_connection
 * @property boolean $is_active
 */
class InventorySchema extends WebModel {
    protected $table = "InventorySchemas";
    protected $fillable = ["is_active"];
    protected $casts = ["is_active" => "boolean"];

    /**
     * @return string
     */
    public function getInventoryConnection(): string {
        return $this->inventory_connection;
    }

    /**
     * @return bool
     */
    public function isActive(): bool {
        return $this->is_active;
    }

    /**
     * @return InventorySchema|null
     */
    public static function getActiveInventorySchema(): ?InventorySchema {
        return self::where('is_active', '=', 1)->first();
    }

    /**
     * @return InventorySchema|null
     */
    public static function getInactiveInventorySchema(): ?InventorySchema {
        return self::where('is_active', '=', 0)->first();
    }
}