<?php
namespace Hilco\Models;

use DB;

class DatafeedFieldBindingValue extends WebModel {
    protected $table = 'DatafeedFieldBindingValues';

    public function datafeedfield_datafeed()
    {
        return $this->belongsTo(DatafeedField_Datafeed::class, 'datafeedfield_datafeed_id', 'id');
    }

    public function datafeedfieldbindingrule()
    {
        return $this->belongsTo(DatafeedFieldBindingRule::class, 'datafeedfieldbindingrule_id', 'id')->orderBy("order");
    }

    public function scopeForBindingRule($query, $bindingRuleId) {
        return $query->where('datafeedfieldbindingrule_id', $bindingRuleId);
    }

    public function scopeForDatafeedFieldAttachment($query, $attachmentId) {
        return $query->where('datafeedfield_datafeed_id',$attachmentId);
    }
}
