<?php
/**
 * Created by PhpStorm.
 * User: steven
 * Date: 7/31/19
 * Time: 5:57 PM
 */

namespace Hilco\GuzzleWrappers\RequestBuilders;


use Illuminate\Foundation\Http\FormRequest;
use Hilco\GuzzleWrappers\APIGuzzleWrapper;
use Hilco\M3Request;

class TaxRequestBuilder extends FormRequestBuilder
{


    public function requestTaxes(){
        $request = $this->buildQueryArray();
        $this->buildAcceptableJson($request);

        $apiGuzzleWrapper = new APIGuzzleWrapper();
        $response = $apiGuzzleWrapper->get('v4/getTaxes', $request)->getBody()->getContents();
        $response = json_decode($response, true);
        return $response['details']['tax'];

    }

    public function buildRequest(){
        \Illuminate\Support\Arr::set($this->attributes, 'query.environment', \Illuminate\Support\Arr::has($this->attributes, 'query.environment') ? \Illuminate\Support\Arr::get($this->attributes, 'query.environment') : env('APP_ENV'));
        \Illuminate\Support\Arr::set($this->attributes, 'query.requestFrom', \Illuminate\Support\Arr::has($this->attributes, 'query.requestFrom') ? \Illuminate\Support\Arr::get($this->attributes, 'query.requestFrom') : 'b2b');

        return http_build_query($this->attributes);
    }

}