<?php

namespace Hilco\Models;
use Eloquent;
use Hilco\SoftDeletes;

/**
 * Hilco\Models\Plant
 *
 * @property mixed $id
 * @property string $plant
 * @property string $plant_name
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant wherePlant($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant wherePlantName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDateUploaded($value)
 */
class Plant extends Eloquent
{
	protected $table = 'Plants';

	const BOZEMAN_CODE      = 'U41';
	const DALLAS_CODE       = 'U21';
    const LASVEGAS_CODE     = 'U31';
	const PLAINVILLE_CODE   = 'U11';

	public function plantAddress() {
	    return $this->hasOne(PlantAddress::class, 'plant_id', 'id');
    }

    public static function defaultPlant() {
	    return self::where('plant', '=', Plant::PLAINVILLE_CODE)->first();
    }

    public static function lasVegasLogicPlants() {
	    return [
	        Plant::PLAINVILLE_CODE,
            Plant::LASVEGAS_CODE,
        ];
    }

    use SoftDeletes;
}
