@if($edit)
    <div class="mceNonEditable component-container" data-component-key="enhancedJumbotron">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.enhanced_jumbotron')</h4>
        <p>@lang('hilco::app.displays_a_large_banner_across_the_entire_width_of_the_page_with_text_overlay')</p>
        <div class="view-full-container">
            @include('hilco::components.targetCustomer.viewSelector', ['alternateViews' => $alternateViews ?? []])
            @include('hilco::components.enhancedJumbotronView',
            [
                'viewId' => 0,
                'full' => $full,
                'webAssetId' => $webAssetId,
                'alttag' => $alttag,
                'buttonLocation' => $buttonLocation,
                'textAreaLocation' => $textAreaLocation,
                'link' => $link,
                'defaultVisibility' => $defaultVisibility ?? 'Visible',
                'visibleDates' => $visibleDates ?? [],
                'visibleDatesFormatted' => $visibleDatesFormatted ?? 'All',
                'default' => true
            ])
            @foreach($alternateViews ?? [] as $altViewId => $altView)
                @include('hilco::components.enhancedJumbotronView',
                [
                    'viewId' => $altViewId,
                    'full' => Arr::get($altView, 'full', false),
                    'webAssetId' => Arr::get($altView, 'webAssetId', ''),
                    'alttag' => Arr::get($altView, 'alttag', ''),
                    'buttonLocation' => Arr::get($altView, 'buttonLocation', ''),
                    'textAreaLocation' => Arr::get($altView, 'textAreaLocation', ''),
                    'link' => Arr::get($altView, 'link', ''),
                    'targetCustomers' => Arr::get($altView, 'targetCustomers', []),
                    'targetCustomersFormatted' => Arr::get($altView, 'targetCustomersFormatted', 'None'),
                    'visibleDates' => Arr::get($altView, 'visibleDates', []),
                    'visibleDatesFormatted' => Arr::get($altView, 'visibleDatesFormatted', 'All'),
                    'default' => false
                ])
            @endforeach
        </div>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('enhancedJumbotron', {
            menuText: '@lang('hilco::app.enhanced_jumbotron')',
            bladeTemplate: 'hilco::components.enhancedJumbotron',
            init: function (body) {
                initViewFunctions(body);
                $(body).on('click', '#enhancedJumbotronThumbnail', function() {
                    var container = $(this).closest('.view-container');
                    assets.finder({
                        successFunction: function(data) {

                            var alt;
                            if(data.alttag != null && data.alttag != ""){
                                alt = data.alttag;
                            }else if(data.name != null && data.name != ""){
                                alt = data.name;
                            }else{
                                alt = 'None'
                            }

                            $(container).find('img#enhancedJumbotronThumbnail')
                                .attr('src', data.url)
                                .attr('alt', alt)
                                .attr('data-web-asset-id', data.id)
                            ;

                            if(alt != 'None') {
                                $(container).find('.enhanced-jumbotron-alttag').attr('data-img-alttag', alt);
                            }
                            $(container).find('.enhanced-jumbotron-alttag').text(alt);
                        }
                    });
                }).on('click', '.enhanced-jumbotron-alttag', function () {
                    var container = $(this).closest('.view-container');
                    var button = $(this);

                    assets.description({
                        successFunction: function (data) {
                            if(data.alttag != null && data.alttag != ""){
                                $(button).attr('data-img-alttag', data.alttag);
                                $(button).text(data.alttag);

                                $(container).find('img#enhancedJumbotronThumbnail')
                                    .attr('alt', data.alttag)
                                ;
                            }
                        }
                    });
                }).on('click', '.set-overlay', function () {
                    $(document).off('click', '#text_description_submit');

                    var mainComponent = $(this).closest('.view-container');

                    var button = $(this);

                    var currentHeader = $(this).attr('data-header-text');
                    document.getElementById("text_description_header").value = currentHeader;

                    var currentButtonCheck = $(this).attr('data-button-check');
                    var check = document.getElementById("include_button");
                    if(currentButtonCheck == 'true'){
                        $(check).prop( "checked", true );
                        $("#button_options").show();
                    }else{
                        $(check).prop( "checked", false );
                        $("#button_options").hide();
                    }

                    document.getElementById("include_button").value = currentButtonCheck;
                    var currentButtonText = $(this).attr('data-button-text');
                    document.getElementById("button_text").value = currentButtonText;
                    var currentButtonLink = $(this).attr('data-button-link');
                    document.getElementById("button_link").value = currentButtonLink;

                    var currentButtonLocation = $(this).attr('data-button-location');
                    if(currentButtonLocation == 'header'){
                        $("#radio_header").prop('checked', true);
                    }else{
                        $("#radio_footer").prop('checked', true);
                    }

                    var currentBody = $(this).attr('data-body-text');
                    document.getElementById("text_description_body").value = currentBody;

                    var currentTextAreaLocation = $(this).attr('data-textarea-location');
                    if(currentTextAreaLocation == 'left'){
                        $("#radio_left").prop('checked', true);
                    }else if(currentTextAreaLocation == 'right'){
                        $("#radio_right").prop('checked', true);
                    }else{
                        $("#radio_center").prop('checked', true);
                    }

                    $("#text-description-modal").find(".overlay-options").show();
                    $("#text-description-modal").modal('show');

                    $(document).on('click', '#text_description_submit', function (e){
                        var header = document.getElementById("text_description_header").value;
                        var buttonCheck = document.getElementById("include_button").checked;
                        if(buttonCheck){
                            var buttonText = document.getElementById("button_text").value;
                            var buttonLink = document.getElementById("button_link").value;
                            var buttonLocation = $("input[name='buttonLocation']:checked").val();
                        }else{
                            var buttonText = '';
                            var buttonLink = '';
                            var buttonLocation = '';
                        }

                        var body = document.getElementById("text_description_body").value;
                        var textAreaLocation = $("input[name='textAreaLocation']:checked").val();

                        $(button).attr('data-header-text', header);
                        $(button).attr('data-button-check', buttonCheck);
                        $(button).attr('data-button-text', buttonText);
                        $(button).attr('data-button-link', buttonLink);
                        $(button).attr('data-button-location', buttonLocation);
                        $(button).attr('data-body-text', body);
                        $(button).attr('data-textarea-location', textAreaLocation);

                        $(mainComponent).find('.header-preview').html(header);
                        $(mainComponent).find('.body-preview').html(body);
                        if(textAreaLocation == 'left'){
                            $(mainComponent).find('.overlay-div').css("left" , 0);
                            $(mainComponent).find('.overlay-div').css("right" , '60%');
                            $(mainComponent).find('.overlay-preview').html("Left");
                        }else if(textAreaLocation == 'right'){
                            $(mainComponent).find('.overlay-div').css("left" , '60%');
                            $(mainComponent).find('.overlay-div').css("right" , 0);
                            $(mainComponent).find('.overlay-preview').html("Right");
                        }else{
                            $(mainComponent).find('.overlay-div').css("left" , 0);
                            $(mainComponent).find('.overlay-div').css("right" , 0);
                            $(mainComponent).find('.overlay-preview').html("Center");
                        }

                        if(buttonText == ''){
                            $(mainComponent).find('.button-preview').html('None');
                            $(mainComponent).find('.link-preview').html('None');
                            $(mainComponent).find('.button-location-preview').html('None');
                            $(mainComponent).find('.header-button').hide();
                            $(mainComponent).find('.footer-button').hide();

                        }else{
                            $(mainComponent).find('.button-preview').html(buttonText);
                            $(mainComponent).find('.link-preview').html(buttonLink);
                            if(buttonLocation == 'header'){
                                $(mainComponent).find('.button-location-preview').html('Header');
                                $(mainComponent).find('.footer-button').hide();
                                $(mainComponent).find('.header-button').show();
                            }else{
                                $(mainComponent).find('.button-location-preview').html('Footer');
                                $(mainComponent).find('.footer-button').show();
                                $(mainComponent).find('.header-button').hide();
                            }
                        }
                        $("#text-description-modal").modal('hide');
                    });
                });
            },
            serialize: function (componentNode) {
                var viewDiv = $(componentNode).find('div.view-container.default');
                var alternateViews = {};
                viewDiv.closest('.view-full-container').find('.view-container.alternate').each(function () {
                    var button = $(this).find('button.set-overlay');

                    var header = $(button).data('header-text');
                    var body = $(button).data('body-text');
                    var buttonText = $(button).data('button-text');
                    var buttonLink = $(button).data('button-link');
                    var textAreaLocation = $(button).data('textarea-location');
                    var buttonLocation = $(button).data('button-location');
                    var alttag = $(this).find('a.enhanced-jumbotron-alttag').data('img-alttag');
                    var targetCustomers = {};
                    try{
                        targetCustomers = JSON.parse($(this).attr('data-target-customers'));
                    }catch (e){
                        //use the empty object
                    }
                    var visibleDates = {};
                    try{
                        visibleDates = JSON.parse($(this).attr('data-visible-dates'));
                    }catch (e){
                        //use the empty object
                    }
                    alternateViews[$(this).attr('data-view-id')] = {
                        webAssetId: $(this).find('img#enhancedJumbotronThumbnail').data('web-asset-id'),
                        alttag: alttag,
                        full: true,
                        header: header,
                        body: body,
                        button: buttonText,
                        link: buttonLink,
                        textAreaLocation: textAreaLocation,
                        buttonLocation: buttonLocation,
                        targetCustomers: targetCustomers,
                        targetCustomersFormatted: $(this).find('.view-targetcustomers').text(),
                        visibleDates: visibleDates,
                        visibleDatesFormatted: $(this).find('.view-visibledates').text(),
                    }
                });

                var button = viewDiv.find('button.set-overlay');

                var header = $(button).data('header-text');
                var body = $(button).data('body-text');
                var buttonText = $(button).data('button-text');
                var buttonLink = $(button).data('button-link');
                var textAreaLocation = $(button).data('textarea-location');
                var buttonLocation = $(button).data('button-location');
                var alttag = viewDiv.find('a.enhanced-jumbotron-alttag').data('img-alttag');
                var visibleDates = {};
                try{
                    visibleDates = JSON.parse(viewDiv.attr('data-visible-dates'));
                }catch (e){
                    //use the empty object
                }


                var result = {
                    webAssetId: viewDiv.find('img#enhancedJumbotronThumbnail').data('web-asset-id'),
                    alttag: alttag,
                    full: true,
                    header: header,
                    body: body,
                    button: buttonText,
                    link: buttonLink,
                    textAreaLocation: textAreaLocation,
                    buttonLocation: buttonLocation,
                    defaultVisibility: viewDiv.attr('data-default-visibility').trim(),
                    visibleDates: visibleDates,
                    visibleDatesFormatted: viewDiv.find('.view-visibledates').text(),
                    alternateViews: alternateViews
                };

                return result;
            },
        });
    </script>
@endif

@if($view)
    @include('hilco::components.targetCustomer.viewRenderer',
['blade' => 'hilco::components.enhancedJumbotronView',
'bladeViewArgs' =>
    ['full' => $full,
    'webAssetId' => $webAssetId,
    'alttag' => $alttag,
    'buttonLocation' => $buttonLocation,
    'textAreaLocation' => $textAreaLocation,
    'link' => $link,
    'defaultVisibility' => $defaultVisibility ?? 'Visible',
    'alternateViews' => $alternateViews?? []],
'mode' => 'view'])
@endif