<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\PartBOM
 *
 * @property-read string $part_no
 * @property-read int $main_part_id
 * @property-read int $quantity
 * @property-read string $comp_no
 * @property-read int $comp_part_id
 * @property-read Part $mainPart
 * @property-read Part $compPart
 */
class PartBOM extends WebModel {
    protected $table = 'PartBOMs';

    /**
     * @return BelongsTo
     */
    public function mainPart(): BelongsTo {
        return $this->belongsTo(Part::class, 'main_part_id', 'id');
    }

    /**
     * @return BelongsTo
     */
    public function compPart(): BelongsTo {
        return $this->belongsTo(Part::class, 'comp_part_id', 'id');
    }

    public function getQuantity() {
        return $this->quantity;
    }
}