<?php
namespace Hilco\Models;

use DB;

class DatafeedField extends WebModel {
    protected $table = 'DatafeedFields';

    public static function checkIfNewFieldsNeedToBeMade() {
        //Check For New Web Attributes
        $sql = <<<SQLEND

       insert into DatafeedFields (tableName, columnName, defaultName, defaultEnabled, defaultOrder, rawValue, groupName, hasCurrencyFormatter)
select 'attribute', attribute_name, attribute_name, 0, 12, concat('(select (select translation from WebModelTranslations where translatable_type = "webAttributeValue" and `column_name` = "attribute_value" and translatable_id = WebAttribute_WebPart.id and `language` = ? and WebModelTranslations.deleted_at = 0) from WebAttribute_WebPart  where WebAttribute_WebPart.webpart_id = WebParts.id and WebAttribute_WebPart.webattribute_id = ',WebAttributes.id,' and WebAttribute_WebPart.deleted_at = 0 and exists ( select 1 from WebAttribute_WebFamily  where WebAttribute_WebFamily.webfamily_id = WebFamilies.id  and WebAttribute_WebFamily.webattribute_id = WebAttribute_WebPart.webattribute_id and WebAttribute_WebFamily.deleted_at = 0))'), 'Web Attributes', 0
from WebAttributes where WebAttributes.deleted_at = 0 and WebAttributes.attribute_name != '' 
and not exists (select 1 from DatafeedFields where tableName = 'attribute' and columnName = WebAttributes.attribute_name and DatafeedFields.deleted_at = 0)
ON DUPLICATE KEY UPDATE deleted_at = 0 ;
SQLEND;

        DB::insert($sql);

        // I don't think datafeedfields should be deleted, but here is the code if we change our mind since I already wrote it
//        $sql = <<<SQLEND
//update DatafeedFields
//set deleted_at = now()
//where DatafeedFields.tableName = 'attribute' and DatafeedFields.deleted_at = 0
//  and not exists (select 1 from WebAttributes where DatafeedFields.columnName = WebAttributes.attribute_name and WebAttributes.deleted_at = 0);
//SQLEND;
//        DB::update($sql);


        // Check for New Customer Attributes
        $sql = <<<SQLEND
insert into DatafeedFields (tableName, columnName, defaultName, defaultEnabled, defaultOrder, rawValue, groupName, hasCurrencyFormatter)
select 'customerAttribute', attribute_name, attribute_name, 0, 12, concat('(select attribute_value from CustomerAttributes where attribute_name = "',attribute_name,'" and part_id = Parts.id and deleted_at = 0)'), 'Customer Attributes', 0
from CustomerAttributes where CustomerAttributes.deleted_at = 0 and CustomerAttributes.attribute_name != '' 
and not exists (select 1 from DatafeedFields where tableName = 'customerAttribute' and columnName = CustomerAttributes.attribute_name and DatafeedFields.deleted_at = 0) group by attribute_name
ON DUPLICATE KEY UPDATE deleted_at = 0 ;
SQLEND;
        DB::insert($sql);

    }

    public function bindingRules() {
        return $this->hasMany(DatafeedFieldBindingRule::class, 'datafeedfield_id', 'id')->orderBy("order");
    }

    public function getBindingRule($binding_type) {
        return $this->bindingRules()->where('binding_type', $binding_type)->first();
    }
    public function hasBinding($binding_type) {
        $bindingRule = $this->getBindingRule($binding_type);
        return $bindingRule != null;
    }

    public function getCalculatedOrderAttribute(){
        return $this->defaultOrder;
    }
    
    public function getCalculatedOrderIndexAttribute(){
        return $this->calculatedOrder - 1;
    }

    public function getSequenceNumberAttribute(){
        return 1;
    }

    public function getDatafeedfieldIdAttribute(){
        return $this->id;
    }
    
    public function getEnabledAttribute(){
        return $this->defaultEnabled;
    }

    public function getOverrideNameAttribute(){
        return '';
    }
    
    use HasModelTranslations;

}
