<?php
/**
 * Created by PhpStorm.
 * User: steven
 * Date: 7/25/19
 * Time: 11:00 AM
 */

namespace Hilco\GuzzleWrappers;


use GuzzleHttp\Client;

/**
 * Class APIGuzzleWrapper
 * @package Hilco\GuzzleWrappers
 *
 */
class APIGuzzleWrapper extends GuzzleWrapper
{
    public function __construct()
    {
        $this->client = config('hilco-api.api_server_url') ? new Client(['base_uri' => config('hilco-api.api_server_url')]) : null;
    }
    public function get($uri, $corollaryAttributes)
    {
        array_set($corollaryAttributes, 'query.environment', array_has($corollaryAttributes, 'query.environment') ? array_get($corollaryAttributes, 'query.environment') : env('APP_ENV'));
        array_set($corollaryAttributes, 'query.requestFrom', array_has($corollaryAttributes, 'query.requestFrom') ? array_get($corollaryAttributes, 'query.requestFrom') : 'b2b');
        if($this->client){
            $response =  $this->client->get($uri, $corollaryAttributes);
            return $response;
        }
    }

}