<?php
/**
 * Created by PhpStorm.
 * User: ntaylor-visionware
 * Date: 12/8/17
 * Time: 4:31 PM
 */

namespace Hilco\Models;

/**
 * Hilco\Models\SalesOrder_SubscriptionGroup
 * @property mixed $salesorder_id
 * @property mixed $subscriptiongroup_id
 * @property SubscriptionGroup $subscriptionGroup
 * @property Order $order
 */
class SalesOrder_SubscriptionGroup extends UuidModel {
    protected $table = 'SalesOrder_SubscriptionGroup';
    protected $fillable = ['salesorder_id', 'subscriptiongroup_id', 'commit_sequence'];

    public function subscriptionGroup() {
        return $this->belongsTo(SubscriptionGroup::class, 'subscriptiongroup_id', 'id');
    }

    public function order() {
        return $this->belongsTo(Order::class, 'salesorder_id', 'id');
    }

}