<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 2/25/20
 * Time: 12:42 PM
 */

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Hilco\Models\Import_SalesOrder
 * @property-read bool $is_legacy
 * @property-read Customer $billToCustomer
 * @property-read Customer $soldToCustomer
 * @property-read CustomerShippingAddress $shipToAddressWithTrashed
 * @property-read Collection|ShipmentUnitItem[] $shipmentUnitItems
 * @property-read Collection|InvoiceLine[] $invoiceLines
 * @property-read Collection|Import_SalesOrderLine[] $importSalesOrderLines
 */
class Import_SalesOrder extends WebModel {
    protected $table = 'Import_SalesOrders';

    public function soldToCustomer() {
        return $this->belongsTo(Customer::class, "soldto_customer_id");
    }

    public function billToCustomer() {
        return $this->belongsTo(Customer::class, "billto_customer_id");
    }

    public function shipToAddressWithTrashed() {
        return $this->belongsTo(CustomerShippingAddress::class, "customershippingaddress_id")->withTrashed();
    }

    public function orderParts()
    {
        return $this->hasMany(Import_SalesOrderLine::class, 'salesorder_id')
            ->join('Parts', 'Import_SalesOrderLines.part_id', '=', 'Parts.id');
    }

    public function shipmentUnitItems(): HasMany {
        return $this->hasMany(ShipmentUnitItem::class, 'importsalesorder_id', 'id');
    }

    public static function getIneligibleStatuses() {
        return ['Rejected', 'Canceled', 'CANCELLED', 'DISCARDED', 'PENDING', 'EXPORTING', 'DENIED', 'SENT_TO_POINTMAN', 'Unapproved', 'Deleted', 'Hold', 'PENDING_APPROVAL', 'PENDING_WEB', 'ADDRESS_PENDING'];
    }

    public function invoiceLines(): HasMany {
        return $this->hasMany(InvoiceLine::class, "importsalesorder_id", "id");
    }

    public function importSalesOrderLines(): HasMany {
        return $this->hasMany(Import_SalesOrderLine::class, "importsalesorder_id", "id");
    }

    public function getReferenceNumber() {
        return $this->web_order_number;
    }

    public function getHilcoOrderNumber() {
        return $this->hilco_order_number;
    }

    public function getOrderDate() {
        return $this->order_date;
    }

    public function getOrderStatus() {
        return $this->order_status;
    }

    public function getCustomerPO() {
        return $this->customer_po;
    }

    public function getCurrencyCode() {
        return $this->currency_code;
    }

    public function getShippingNumber() {
        return $this->shipping_no;
    }

    public function getShippingLine1() {
        return $this->shipping_line1;
    }

    public function getShippingLine2() {
        return $this->shipping_line2;
    }

    public function getShippingLine3() {
        return $this->shipping_line3;
    }

    public function getShippingCity() {
        return $this->shipping_city;
    }

    public function getShippingState() {
        return $this->shipping_state;
    }

    public function getShippingZip() {
        return $this->shipping_zip;
    }

    public function getShippingCountry() {
        return $this->shipping_country;
    }
}