<?php

namespace Hilco\Models;

use Auth;
use Illuminate\Database\Eloquent\Model;

class WebCart extends WebModel
{
    protected $table = 'WebCarts';
    protected $fillable = ['quantity'];

    public function webPart() {
        return $this->hasOne(WebPart::class, 'part_number', 'part_number');
    }

    public function webUser() {
        return $this->hasOne(WebUser::class, 'webuser_id', 'id');
    }

    public function priceList() {
//        return $this->hasOne(PriceList::class)
    }

    public function scopeForUser($query, $webuserId) {
        return $query->where('webuser_id', $webuserId);
    }

    public function scopePartNumber($query, $partNumber) {
        return $query->where('part_number', $partNumber);
    }

//    public function product() {
//        return $this->belongsTo(Product::class);
//    }

    public function getExtendedPriceAttribute() {
        return $this->webPart->getCustomerPrice($this->quantity) * $this->quantity;
    }

    public static function add(WebPart $webPart, $quantity = 1)
    {
        $instance = new static;
        $instance->webuser_id = Auth::id();
        $instance->part_number = $webPart->part_number;
        $instance->quantity = $quantity;
        $instance->save();
        return $instance;
    }

    public static function remove($userId, $partNumber)
    {
        $instance = new static;
        return $instance::where(['part_number' => $partNumber, 'webuser_id' => $userId])->delete();
    }

    public static function cartItems($webUserId = false) {
        if ($webUserId === false) $webUser = auth()->user();
        else $webUser = WebUser::find($webUserId);
        if (is_null($webUser)) return [];

        return self::forUser($webUser->id)->with(['webPart' => function ($query) use ($webUser) {
            return $query->with(['part' => function ($query) use ($webUser) {
                $query->with(['prices' => function ($query) use ($webUser) {
                    $query
                        ->where('currency', $webUser->currency)
                        ->where('price_list', $webUser->default_price_list)
//                        ->whereRaw('PriceLists.quantity_level >= WebCarts.quantity')
                    ;
                }]);
            }])->with('webFamily');
        }])->get();
    }

}
