<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;


/**
 * Hilco\Models\Promo
 *
 */
class Promo extends Model
{
	protected $table = 'Promos';
	protected $fillable = ['name', 'type', 'WebPartIds', 'bonus', 'all_in_cart', 'active', 'expire_at'];

	public static $types = [
		'Price Discount'=>"price-discount",
		'Delivery Discount'=>"delivery-discount"
	];

	public function webParts() {
		return $this->belongsToMany(WebPart::class, 'Promo_WebPart', 'promo_id', 'webpart_id');
	}

	public function setWebPartIdsAttribute($ids) {
		$this->save();
		$this->webParts()->sync($ids);
	}

	public function rules(){
		return $this->hasMany(PromoRule::class, 'promo_id', 'id');
	}

	public function scopeActive($query){
		$date = date('Y-m-d H:i:s',time());
		return $query->where('active',1)
				     ->where('expire_at','>=',$date);
	}

	public function scopeForAllCart($query){
		return $query->where('all_in_cart',1);
	}
	
	public function scopeForWebPart($query){
		return $query->where('all_in_cart',0);
	}
}
