<?php

namespace Hilco\Models;

/**
 * Class WebSilo_AvailableLanguage
 * @package Hilco\Models
 */
class WebSilo_AvailableLanguage extends WebModel {
    protected $table = 'WebSilo_AvailableLanguage';
    protected $fillable = ['websilo_id', 'availablelanguage_id', 'is_default'];
    protected $casts = ['is_default' => 'boolean',];

    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function availableLanguage() {
        return $this->belongsTo(AvailableLanguage::class, 'availablelanguage_id', 'id');
    }
}