<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:35 AM
 */

namespace Hilco\Listeners;


use Hilco\Events\UserWasRegistered;
use Illuminate\Contracts\Mail\Mailer;
use Illuminate\Support\Facades\Mail;

/**
 * Sends an email to customer service to alert that a new user was created.
 *
 * Class EmailNewUserAlert
 * @package Hilco\Listeners
 */
class EmailNewUserAlert {

    public function construct() {

    }

    public function handle(UserWasRegistered $event) {
        if ($event->selfCreated) {
            Mail::send('hilco::emails.newUserAlert', ['webUser' => $event->webUser], function ($mail) use ($event) {
                foreach (config('hilco.emailDestinations.newUserAlert.to', []) as $to) {
                    if ($to) $mail->to($to);
                }

                foreach (config('hilco.emailDestinations.newUserAlert.bcc', []) as $bcc) {
                    if ($bcc) $mail->bcc($bcc);
                }

                $mail->subject(trans('hilco::email.newUserAlertSubject', ['customerNumber' => $event->webUser->customer->cust_no]));
            });
        }
    }
}