<?php

namespace Hilco\Models;

/**
 * StandardNotes model class
 * @property integer $id
 * @property string $tltxid_internalid
 * @property string $tllino_lineno
 * @property string $cgtxge_textid
 * @property string $cgsrwr_searchkey
 * @property string $cgtx40_desc
 * @property string $tltxvr_textblock
 * @property string $tllncd_langcode
 * @property string $tldivi_division
 * @property string $tltx60_text
 */
class StandardNote extends WebModel {
    protected $table = 'StandardNotes';
    protected $fillable = [
        'tltxid_internalid',
        'tllino_lineno',
        'cgtxge_textid',
        'cgsrwr_searchkey',
        'cgtx40_desc',
        'tltxvr_textblock',
        'tllncd_langcode',
        'tldivi_division',
        'tltx60_text',
    ];
    // ION/M3 API field => MySQL table column
    protected static $fieldMap = [
        'TLTXID' => 'tltxid_internalid',
        'TLLINO' => 'tllino_lineno',
        'CGTXGE' => 'cgtxge_textid',
        'CGSRWR' => 'cgsrwr_searchkey',
        'CGTX40' => 'cgtx40_desc',
        'TLTXVR' => 'tltxvr_textblock',
        'TLLNCD' => 'tllncd_langcode',
        'TLDIVI' => 'tldivi_division',
        'TLTX60' => 'tltx60_text',
    ];

    /**
     * @return string[]
     */
    public static function getFieldMap(): array {
        return self::$fieldMap;
    }
}