<?php

namespace Hilco\Models;

/**
 * Class PromotionTriggerDetails
 * @package Hilco\Models
 */
abstract class PromotionTriggerDetails extends WebModel {
    /**
     * Get relationship to PromotionTriggers row
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function trigger() {
        return $this->hasOne(PromotionTrigger::class, 'trigger_id', 'id');
    }

    /**
     * Boolean, all promo trigger types need to implement to use their specific logic
     * @param Customer $soldToCustomer
     * @param array $webCartItems
     * @return mixed
     */
    public abstract function isTriggered(Customer $soldToCustomer, $webCartItems = []);

    /**
     * promo trigger types should implement if there post operations that should happen after promo is applied
     * @param $soldToCustomer
     * @return mixed
     */
    public abstract function postTriggerOperation(Customer $soldToCustomer);

    /**
     * Boolean, any promo trigger that can use the Almost Qualifying Header should implement this and return 'true'
     * otherwise return 'false'
     * @return bool
     */
    public abstract function hasAlmostQualifyingField();

    /**
     * Any promo trigger that can use the Almost Qualifying Header should implement this and
     * @param Customer $soldToCustomer
     * @param $webCartItems
     * @return bool
     */
    public abstract function isAlmostQualifying(Customer $soldToCustomer, $webCartItems);

    use HasCommitSequence;
}