@if($edit)
    <div class="mceNonEditable component-container" data-component-key="assetsTable">
<a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('app.assets_table')</h4>
        <p>@lang('app.displays_a_table_of_links_to_asset_files')</p>
        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                <div data-assets-table-id="{{ $assetsTableId }}" class="assets-table-container">
                    <div class="assets-table-assets-container" style="font-size: 10pt; font-weight: normal;">
                        <div class="row asset-row-header">
                            <div class="col-md-4">
                                @lang('app.asset_name')
                            </div>
                            <div class="col-md-6">
                                @lang('app.description')
                            </div>
                            <div class="col-md-2">
                            </div>
                        </div>
                        {{--@foreach (\Hilco\Models\WebAsset::findMany(array_keys($webAssets)) as $webAsset)--}}
                        {{--@endforeach--}}
                    </div>
                    <br>
                    <a href="#" class="btn btn-primary add-table-link-button">@lang('app.add_asset')</a>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        if (typeof _assetsTables == 'undefined') var _assetsTables = [];
        _assetsTables[{{$assetsTableId}}] = {!! \Hilco\Models\WebAsset::findMany(array_keys($webAssets))->toJson() !!};
    </script>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        function addAssetsTableRow(table, data) {
            var newRow = $($('#assets-table-row-template').html()).attr('data-web-asset-id', data.id);
            newRow.find('.asset-name').text(data.name);
            newRow.find('.asset-description').text(data.description);
            table.find('.assets-table-assets-container').append(newRow);
        }

        registerComponent('assetsTable', {
            menuText: '@lang('app.assets_table')',
            bladeTemplate: 'hilco::components.assetsTable',
            init: function (body) {

                if (_assetsTables) {
                    $.each(_assetsTables, function (tableId, webAssets) {
                        $.each(webAssets, function (index, webAsset) {
                            addAssetsTableRow($(body).find('.assets-table-container[data-assets-table-id="'+tableId+'"]'), webAsset);
                        });
                    });
                }

                $(body).on('click', 'a.add-table-link-button', function () {
                    var table = $(this).closest('.assets-table-container');

                    assets.finder({
                        successFunction: function (data) {
                            addAssetsTableRow(table, data);
                        }
                    })
                });
                $(body).on('click', 'a.delete-table-link-button', function () {
                    $(this).closest('.asset-container').remove();
                });
            },
            serialize: function (componentNode) {
                var data = {
                    assetsTableId: $(componentNode).find('.assets-table-container').data('assets-table-id'),
                    webAssets: {},
                };
                $(componentNode).find('.asset-container').each(function () {
                    data.webAssets[$(this).data('web-asset-id')] = {};
                });
                return data;
            },
        });
    </script>

    <div id="assets-table-row-template" style="display: none;">
        <div class="row asset-container">
            <div class="col-md-4 asset-name"></div>
            <div class="col-md-4 asset-description"></div>
            <div class="col-md-4"><a href="#" class="delete-table-link-button">@lang('app.remove')</a></div>
        </div>
    </div>
@endif

@if($view)
    <div class="row container center-block">
        <table class="table table-condensed table-striped">
            @foreach (\Hilco\Models\WebAsset::findMany(array_keys($webAssets)) as $webAsset)
                <tr>
                    <td>
                        <i class="fa {{ $webAsset->icon }}"></i> <a href="{{ $webAsset->download_url }}">{{ $webAsset->name }}</a>
                    </td>
                </tr>
            @endforeach
        </table>
    </div>
@endif
