<?php

namespace Hilco\Models;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class CustomerRewardsStatus extends WebModel
{
	protected $table = 'CustomerRewardsStatus';
	protected $fillable = [];
	protected $appends = ['product_category_group_name'];

	public function customer() {
	    return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function productCategoryGroup() {
	    return $this->belongsTo(ProductCategoryGroup::class, 'productcategorygroup_id');
    }

    public function getProductCategoryGroupNameAttribute() {
	    return $this->productCategoryGroup->product_category_group;
    }
}
