<?php

namespace Hilco\Models;

/**
 * Hilco\Models\WebLandingPageVersion
 *
 * @property integer $id
 * @property string $name
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read mixed $context
 * @property-read mixed $default_context
 * @property-read mixed $web_layout
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageVersion whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageVersion whereName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageVersion whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageVersion whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageVersion whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageVersion named($name)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebModel joinContext($contextId = false)
 * @mixin \Eloquent
 * @property string $slug
 * @property string $language
 * @property string $detail
 * @property string $css
 * @property integer $weblandingpage_id
 * @property integer $createdby_user_id
 * @property integer $removedby_user_id
 * @property boolean $requires_auth
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageVersion whereSlug($value)
 */
class WebLandingPageVersion extends WebModel implements HasLandingPageInterface {

	protected $table = "WebLandingPageVersions";
    protected $fillable = ['name', 'detail', 'slug', 'language', 'removedby_user_id', 'createdby_user_id', 'css', 'requires_auth'];
    protected $casts = ['requires_auth' => 'boolean'];

    public function slugUrl() {
        return route('draft.slug', [$this->slug]);
    }

    public function scopeVisible($query) {
        return $query;
    }

	use HasSlug, HasLandingPage;

    /**
     * @param WebLandingPage $webLandingPage
     * @return WebModel|void
     */
    public static function createVersionFromPage ($webLandingPage) {
        $version = new WebLandingPageVersion;
        $version->weblandingpage_id     = $webLandingPage->id;
        $version->name                  = $webLandingPage->name;
        $version->slug                  = $webLandingPage->slug;
        $version->detail                = $webLandingPage->detail;
        $version->language              = $webLandingPage->language;
        $version->createdby_user_id     = auth()->user()->id;
        $version->save();
    }

    public static function IsExists($name = null, $slug = null){
        if(!isset($name) && !isset($slug)) return true;
        $query = null;

        if(isset($name)){
            if(!isset($query)) $query = self::named($name);
            else $query = $query->named($name);
        }

        if(isset($slug)){
            if(!isset($query)) $query = self::where('slug',$slug);
            else $query = $query->orWhere('slug',$slug);
        }
        $result = $query->count();
        return (isset($result) && $result > 0);
    }

    public function webGroups() {
        return $this->belongsToMany(WebGroup::class, 'WebGroup_WebLandingPage', 'weblandingpage_id', 'webgroup_id');
    }

    public function getParentRelationName()
    {
        return false;
    }

    public static function getAvailableLandingPageVersions(){
        return WebLandingPageVersion::pluck('name', 'id');
    }

    public function webBrands()
    {
        return $this->belongsToMany(WebBrand::class, 'WebBrand_WebLandingPage', 'weblandingpage_id', 'webbrand_id');
    }

    public static function getMostRecentForPage($page) {
        return WebLandingPageVersion::where('weblandingpage_id', $page->id)->orderBy('date_created', 'desc')->first();
    }

    /**
     * @return bool
     */
    public function requiresAuth(): bool {
        return $this->requires_auth;
    }
}
