<?php

namespace Hilco\Models;

use DB;
use Hilco\Models\SelectsRelatedCount;

/**
 * Class WebFamily_WebCollection
 * @package Hilco\Models
 * @property int $webfamily_id
 * @property int $webcollection_id
 * @property bool $is_featured
 * @property int $display_order
 */
class WebFamily_WebCollection extends WebModel {
    protected $table = 'WebFamily_WebCollection';
    protected $fillable = ['webfamily_id', 'webcollection_id', 'is_featured', 'display_order', 'commit_sequence'];

    public function webFamily() {
        return $this->belongsTo(WebFamily::class, 'webfamily_id', 'id');
    }

    public function webCollection() {
        return $this->belongsTo(WebCollection::class, 'webcollection_id', 'id');
    }

    use HasCommitSequence;
}
