<?php

namespace Hilco\Models;

/**
 * Class WebCategory_WebGroup
 * @package Hilco\Models
 * @property int $webcategory_id
 * @property int $webgroup_id
 * @property bool $is_featured
 * @property int $display_order
 */
class WebCategory_WebGroup extends WebModel {
    protected $table = 'WebCategory_WebGroup';
    protected $fillable = ['webcategory_id', 'webgroup_id', 'is_featured', 'display_order', 'commit_sequence'];

    public function webCategory() {
        return $this->belongsTo(WebCategory::class, 'webcategory_id', 'id');
    }

    public function webGroup() {
        return $this->belongsTo(WebGroup::class, 'webgroup_id', 'id');
    }

    use HasCommitSequence;
}