<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Model Class CenposAuthorization
 * @property integer id
 * @property integer stagedorder_id
 * @property string status
 * @property string auth_code
 * @property string auth_reference_num
 * @property string last_four_digits
 * @property float authorized_amount
 * @property string date_authorized
 * @property boolean onetime_auth
 * @property string void_code
 * @property string void_reference_num
 * @property string origin
 * @property StagedOrder stagedOrder
 */
class CenposAuthorization extends StagingModel {
    protected $table = "CenposAuthorizations";

    /**
     * @return BelongsTo
     */
    public function stagedOrder(): BelongsTo {
        return $this->belongsTo(StagedOrder::class, "stagedorder_id", "id");
    }

    /**
     * @return string
     */
    public function getAuthCode(): string {
        return $this->auth_code;
    }

    /**
     * @return float
     */
    public function getAuthorizedAmount(): float {
        return $this->authorized_amount;
    }

    /**
     * @return string
     */
    public function getAuthReferenceNum(): string {
        return $this->auth_reference_num;
    }

    /**
     * @return string
     */
    public function getLastFour(): string {
        return $this->last_four_digits;
    }

    /**
     * @return string
     */
    public function getDateAuthorized(): string {
        return $this->date_authorized;
    }

    /**
     * @return string
     */
    public function getStatus(): string {
        return $this->status;
    }

    /**
     * @return bool
     */
    public function isOneTimeAuth(): bool {
        return $this->onetime_auth;
    }
}