<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 7/16/18
 * Time: 4:18 PM
 */

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;

/**
 * Hilco\Models\ApprovalReason
 *
 * @property integer $id
 * @property string $name
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $commit_sequence
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalReason whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalReason whereName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalReason whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalReason whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalReason whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalReason whereCommitSequence($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalReason whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalReason byName($approvalReasonName)
 * @mixin \Eloquent
 */

class ApprovalReason extends WebModel {
    protected $table = "ApprovalReasons";

    const EXPRESS_RX_CC_APPROVAL = 'Express Rx CC Approval';
    const EXPRESS_RX_STOCK_APPROVAL = 'Express Rx Stock Approval';
    const FREIGHT_WEB_ERROR_APPROVAL = 'Freight Web Error Approval';
    const REGULATED_ITEM_APPROVAL = 'Regulated Item Approval';

    public function scopeByName($query, $approvalReasonName) {
        return $query->where('name', $approvalReasonName);
    }
}