<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use Venturecraft\Revisionable\RevisionableTrait;

class WebSilo extends HierarchyModel implements HasLandingPageInterface {
	protected $table = "WebSilos";
	protected $fillable = ['name', 'slug', 'webRoleIds', 'is_visible', 'detail'];
	protected $context_attributes = [];
	protected $casts = [
	    'is_visible' => 'boolean'
	];
	
	public function webGroups() {
		return $this->belongsToMany(WebGroup::class, 'WebGroup_WebSilo', 'websilo_id', 'webgroup_id');
	}

	public function webLinkCategories() {
		return $this->belongsToMany(WebCategory::class, 'WebLinkCategory_WebSilo', 'websilo_id', 'weblinkcategory_id');
	}

	public function webLinks() {
		return $this->belongsToMany(WebCategory::class, 'WebLink_WebSilo', 'websilo_id', 'weblink_id');
	}

	public function webRoles() {
		return $this->belongsToMany(Role::class, 'Role_WebSilo', 'websilo_id', 'role_id');
	}

	public function featuredChildren() {
	    return $this->webGroups();
    }

	public function setWebRoleIdsAttribute($ids) {
		$this->save();
		$this->webRoles()->sync($ids);
	}

	public function getAssetPrefix() {
		return "WebSilos/{$this->id}/webContexts";
	}

	public function scopeVisible(Builder $query) {
		return $query
			->where('WebSilos.is_visible', '1')
			->whereHas('webGroups', function ($query) {
				return $query->visible();
			})
		;
	}

    public function slugUrl() {
        //return route('silos.slug', [$this->slug]);
    }

    use HasSlug, HasLandingPage, RevisionableTrait;
}
