<?php

namespace Hilco\Models;

use Blade;
use Storage;

trait HasLandingPage {
    public function webAttributeFilters() {
        return $this->morphMany(WebAttributeFilter::class, 'filterable')->has('webAttribute')->with('webAttribute');
    }

    public function getFiltersAttribute() {
        $filters = $this->webAttributeFilters;
        $attributes = [];
        foreach ($filters as $filter) {
            $attributes[$filter->webAttribute->id]['id'] = $filter->webAttribute->id;
            $attributes[$filter->webAttribute->id]['attribute_name'] = $filter->webAttribute->attribute_name;
            $attributes[$filter->webAttribute->id]['webAttributeFilters'][$filter->id]['id'] = $filter->id;
            $attributes[$filter->webAttribute->id]['webAttributeFilters'][$filter->id]['display_as'] = $filter->display_as;
        }
        foreach ($attributes as $id => $attribute) {
            $attributes[$id]['webAttributeFilters'] = array_sort($attribute['webAttributeFilters'], function ($item) {
                return $item['display_as'];
            });
        }
        array_sort($attributes, function ($item) {
            return $item['attribute_name'];
        });
        return $attributes;
    }

}