<div class="col-md-12">
    <div class="panel panel-danger">
        <div class="panel-heading">
            <h3 class="panel-title text-center">Best Sellers</h3>
        </div>
        <div class="panel-body" style="height: 280px">
            <div id="best-sellers-carousel">
                @foreach ($bestSellers as $family)
                    <div class="home-best-seller-item" style="display: none;">
                        <div class="image">
                            <img class="img-responsive" style="width: auto; max-height: 120px; margin: 0 auto;" src="{{ $family->getImageLink(300, 300) }}" alt="{{ $family->name }}">
                        </div>
                        <div class="caption">
                            <a href="{{ route('family.slug', [$family->slug]) }}">
                            <span class="h4">
                                {{ $family->name }}
                            </span>
                            </a>
                        </div>
                        @if($family->webParts->count() > 1)
                            <a class="btn btn-sm btn-default" href="{{ route('family.slug', [$family->slug]) }}">See Product Options</a>
                            <div class="price text-danger">
                                ${{ number_format($family->price_range[0], 2) }} - ${{ number_format($family->price_range[1], 2) }}
                            </div>
                        @else
                            <div class="price text-danger">
                                ${{ number_format($family->price, 2) }}
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
