<?php

namespace Hilco\Models;

use Illuminate\Support\Facades\Auth;
use DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
/**
 * Hilco\Models\WebLandingPage
 *
 * @property integer $id
 * @property string $position
 * @property string $title
 * @property string $date_modified
 * @property string $date_created
 * @property string $deleted_at
 */
class WebLinkCategory extends Model {

    use \Hilco\SoftDeletes;

    const CREATED_AT = 'date_created';
    const UPDATED_AT = 'date_modified';

    protected $table = "WebLinkCategories";
    protected $fillable = ['position','title','order','webSiloIds'];
    public static $positions =['hb2b-footer'=>'Hilco footer','hb2b-header'=>'Hilco header'];

    public function links() {
        return $this->hasMany(WebLink::class, 'web_link_category_id');
    }

    public function webSilos() {
        return $this->belongsToMany(WebSilo::class, 'WebLinkCategory_WebSilo', 'weblinkcategory_id', 'websilo_id');
    }

    public function setWebSiloIdsAttribute($ids) {
        $this->save();
        $this->webSilos()->sync($ids);
    }

    public function scopeAvailableForUser($query){
        $user = Auth::user();
        return $query
            ->leftJoin('WebLinkCategory_WebSilo as WLCWS', 'WLCWS.weblinkcategory_id', '=', 'WebLinkCategories.id')
            ->leftJoin('WebSilos as WS', 'WS.id', '=', 'WLCWS.websilo_id')
            ->select(DB::raw('WebLinkCategories.*'));
    }

    public function scopeInFooter($query){
        return $query->where('position', 'hb2b-footer');
    }

}
