<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Model;

class WebCollection_Solr extends Model
{
    protected $table = 'WebCollection_Solr';
    protected $fillable = ['webCollection_id', 'hash', 'visible', 'lastAction'];

    const UPDATED_AT = 'date_modified';
    const CREATED_AT = 'date_created';

    use \Hilco\SoftDeletes;

    public function item() {
        return $this->belongsTo(WebCollection::class, 'webCollection_id', 'id');
    }

    public function scopeByDeletedRecords($query) {
        return $query
            ->whereRaw("(lastAction IN ('Added', 'Updated') OR visible != 0)")
            ->whereDoesntHave('item', function ($query) {
                $query
                    ->has('webCategories.webGroups')
                    ->whereHas('webFamilies', function ($query) {
                        $query->whereHas('webParts', function ($query) {
                            $query->where('is_visible', 1)->has('part');
                        });
                    });
            });
    }
}