<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AdminPermission extends Model {
	use \Hilco\SoftDeletes;

	const CREATED_AT = 'date_created';
	const UPDATED_AT = 'date_modified';

	protected $table = 'Permissions';
	protected $fillable = ['permission_title', 'permission_slug', 'permission_description', 'is_enabled'];

	public function users()
	{
		return $this->belongsToMany(WebUser::class, 'Permission_WebUser');
	}

	public function roles()
	{
		return $this->belongsToMany(Role::class, 'Permission_Role', 'permission_id', 'role_id');
	}
}