<?php

namespace Hilco\Models;


class WebPeerGroupClickTrackingEvent extends WebModel {
    protected $table = 'WebPeerGroupClickTrackingEvents';
    protected $fillable = ['webuser_id', 'customercategory_id', 'webfamily_id', 'version', 'commit_sequence'];

    use HasCommitSequence;

    public static function log(WebUser $webUser = null, $webFamilySlug = null) {
        if ($webUser && $webFamilySlug) {
            $data = [];

            $data['webuser_id'] = $webUser->id;
            $data['customercategory_id'] = $webUser->customer->overrideCustomerCategory->id;

            $webFamily = WebFamily::where('slug', $webFamilySlug)->first();
            $data['webfamily_id'] = $webFamily->id;

            self::create($data);
        }
    }

}