<?php

namespace Hilco\Models;

use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * M3 price lists table with quantity breaks
 * @property-read string $PRRF
 * @property-read string $SAPR
 * @property-read string $NTCD
 */
class OPRICL extends Model {
    protected $table = "OPRICL";

    /**
     * @return mixed
     */
    public function getPriceList() {
        return $this->PRRF;
    }

    /**
     * @return string
     */
    public function getSalePrice() {
        return $this->SAPR;
    }

    /**
     * @return string
     */
    public function getQuantity() {
        return $this->QTYL;
    }

    /**
     * @return string
     */
    public function getNetCode() {
        return $this->NTCD;
    }

    /**
     * @return bool
     */
    public function isContractPrice() {
        return $this->getNetCode() == "1";
    }

    /**
     * @param $pricelistConnection , "hilco-pricelist-a" or "hilco-pricelist-b" (fetch from PriceListSchemas table)
     * @param $priceListDesc , e.g. "US_CATALOG" (CustomerSegments.def_pricelist_desc)
     * @param $custNo, e.g., "70727975" (Customers.cust_no) OR ""
     * @param $currency , e.g., "USD" (Customers.currency)
     * @param $itemNo , e.g. "1097264" (Parts.part_no, WebParts.part_number, etc)
     * @param $quantity , e.g., 1
     * @return OPRICL|Builder|Model|object|null
     */
    public static function findPriceRecordForItem ($pricelistConnection, $priceListDesc, $custNo, $currency, $itemNo, $quantity) {
        return
            OPRICL::on($pricelistConnection)
                    ->where('PRRF', $priceListDesc)
                    ->where('CUNO', $custNo)
                    ->where('CUCD', $currency)
                    ->where('ITNO', $itemNo)
                    ->where('QTYL', '<=', $quantity)
                    ->where('FVDT', '<=', DB::raw("DATE_FORMAT(CURDATE(), '%Y%m%d')"))
                    ->where('VFDT', '<=', DB::raw("DATE_FORMAT(CURDATE(), '%Y%m%d')"))
                    ->where("LVDT", ">=", DB::raw("DATE_FORMAT(CURDATE(), '%Y%m%d')"))
                    ->where("deleted", "=", 0)
                    ->orderBy('QTYL', 'DESC')
                    ->limit(1)
                    ->first();
    }

    /**
     * @param $pricelistConnection
     * @param $priceListDesc
     * @param $custNo
     * @param $currency
     * @param $itemNo
     * @return mixed
     */
    public static function findAllPriceRecordsForItem ($pricelistConnection, $priceListDesc, $custNo, $currency, $itemNo) {
        return
            OPRICL::on($pricelistConnection)
                ->where('PRRF', $priceListDesc)
                ->where('CUNO', $custNo)
                ->where('CUCD', $currency)
                ->where('ITNO', $itemNo)
                ->where('FVDT', '<=', DB::raw("DATE_FORMAT(CURDATE(), '%Y%m%d')"))
                ->where('VFDT', '<=', DB::raw("DATE_FORMAT(CURDATE(), '%Y%m%d')"))
                ->where("LVDT", ">=", DB::raw("DATE_FORMAT(CURDATE(), '%Y%m%d')"))
                ->where("deleted", "=", 0)
                ->orderBy('QTYL', 'ASC')
                ->get();
    }
}