<?php

namespace Hilco\Models;

/**
 * Hilco\Models\PaymentTerm
 * @property-read integer $id
 * @property-read string $payment_terms_code
 * @property-read string $payment_terms_desc
 * @property-read string $de_desc
 * @property-read string $fr_desc
 */
class PaymentTerm extends WebModel {
	protected $table = 'PaymentTerms';

    public function order() {
        return $this->hasMany(Order::class, 'paymentterm_id', 'id');
    }

    /**
     * @param string|null $activeLang
     * @return string
     */
    public function getDescForDisplay (string $activeLang = null): string {
        if (is_null($activeLang)) {
            $activeLang = b2b()->activeLanguage();
        }
        switch ($activeLang) {
            case $activeLang == 'de_DE': {
                return $this->de_desc;
            }
            case $activeLang == 'fr_CA':
            case $activeLang == 'fr_FR': {
                return $this->fr_desc;
            }
            case $activeLang == 'en_DE':
            case $activeLang == 'en_US':
            default: {
                return $this->payment_terms_desc;
            }
        }
    }

    /**
     * @return bool
     */
    public function isCreditCardTerms(): bool {
        return $this->payment_terms_code == 'CC';
    }
}