<?php
/**
 * Created by PhpStorm.
 * User: ntaylor-visionware
 * Date: 12/8/17
 * Time: 4:31 PM
 */

namespace Hilco\Models;

/**
 * Class Promotion_SalesOrder
 * @package Hilco\Models
 * @property mixed $id
 * @property integer $promotion_id
 * @property mixed $salesorder_id
 * @property bool $applied
 * @property integer $commit_sequence
 */
class Promotion_SalesOrder extends UuidModel {
    protected $table = 'Promotion_SalesOrder';
    protected $fillable = ['id', 'promotion_id', 'salesorder_id', 'applied', 'commit_sequence'];

    /**
     * @param Order $salesOrder
     * @param Promotion $promotion
     * @param int $commit_sequence
     * @return Promotion_SalesOrder
     */
    public static function createForOrder (Order $salesOrder, Promotion $promotion, int $commit_sequence): Promotion_SalesOrder {
        $promoSalesOrder = new Promotion_SalesOrder([
            'id' => generateUUID(),
            'salesorder_id' => $salesOrder->id,
            'promotion_id' => $promotion->id,
            'applied' => 1,
            'commit_sequence' => $commit_sequence
        ]);
        $promoSalesOrder->save();
        return $promoSalesOrder;
    }

    public function promotion() {
        return $this->belongsTo(Promotion::class, 'promotion_id', 'id');
    }

    public function order() {
        return $this->belongsTo(Order::class, 'salesorder_id', 'id');
    }

}