<?php

namespace Hilco\Models;

trait SolrTrait {
    private function sanitizeSolrValue($value) {
        $xx = $value;

        $value = strip_tags(html_entity_decode($value));

        //we don't take kindly to weirdo characters around here
        $value = preg_replace('/[^[:alnum:][:punct:][:space:]]/', '', $value);

        //replace some characters with spaces
        $value = preg_replace('%[]/\\\\&]%', ' ', $value);

        //remove extra spaces
        $value = trim(preg_replace('/\s+/', ' ', $value));

        return $value;
    }

    /**
     * Removes duplicate words from a string containing multiple words separated by spaces.
     */
    private function deduplicateSolrValue($value) {
        return implode(' ', array_unique(explode(' ', $value)));
    }
}