<?php

namespace Hilco\Models;

/**
 * Class WebPartProductFeature
 * @package Hilco\Models
 * @property integer $webpart_id
 * @property string $feature_text
 * @property integer $display_order
 * @property string $language_code
 */
class WebPartProductFeature extends WebModel {
    protected $table = "WebPartProductFeatures";
    protected $fillable = ["webpart_id", "feature_text", "display_order", "language_code"];

    public function webPart() {
        return $this->belongsTo(WebPart::class, 'webpart_id', 'id');
    }
}