<?php

namespace Hilco\Models;

/**
 * Class PromotionView
 * @package Hilco\Models
 * @property integer $promotion_id
 * @property string $language_code
 * @property string $cart_header
 * @property string $cart_header_title
 * @property string $checkout_header
 * @property string $checkout_header_title
 * @property string $homepage_banner_text
 * @property string $homepage_banner_link
 * @property string $almost_header
 * @property string $almost_header_title
 */
class PromotionView extends WebModel {
    protected $table = 'PromotionViews';
    protected $fillable = [
        'promotion_id', 'language_code',
        'cart_header', 'checkout_header',
        'cart_header_title', 'checkout_header_title',
        'homepage_banner_text', 'homepage_banner_link',
        'almost_header', 'almost_header_title',
    ];

    public function promotion() {
        return $this->belongsTo(Promotion::class, 'promotion_id', 'id');
    }
}