<?php

namespace Hilco\Models;

/**
 * Class DeliveryMethod
 * @package Hilco\Models
 * @property integer $id
 * @property string delivery_method_code
 * @property string description
 * @property string carrier
 * @property bool is_for_billrcvr
 * @property string billrcvr_desc
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\DeliveryMethod whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\DeliveryMethod whereDeliveryMethodCode($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\DeliveryMethod whereDescription($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\DeliveryMethod whereCarrier($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\Hilco\Models\DeliveryMethod isForBillReceiver()
 */
class DeliveryMethod extends WebModel {
    protected $table = "DeliveryMethods";

    // UPS Supersaver
    const EXPRESSRX_DELIVERY_METHOD = "USS";

    public function scopeIsForBillReceiver($query) {
        return $query->whereRaw("is_for_billrcvr = 1");
    }

    /**
     * @return DeliveryMethod|null
     */
    public static function getExpressRxMethod(): ?DeliveryMethod {
        return DeliveryMethod::where('delivery_method_code', self::EXPRESSRX_DELIVERY_METHOD)->first();
    }

    public function getDeliveryMethodCode(): string {
        return $this->delivery_method_code;
    }
}