<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\Customer_PharmacyLicense
 * @property integer $id
 * @property string $cust_no
 * @property integer $customer_id
 * @property string $state_license_number
 * @property mixed $customerpharmacyinfo_id
 * @property string $shipto_address_no
 * @property-read Customer $customer
 * @property-read CustomerPharmacyInfo $customerPharmacyInfo
 */
class Customer_PharmacyLicense extends WebModel {
    protected $table = "Customer_PharmacyLicense";

    /**
     * @return BelongsTo
     */
    public function customer(): BelongsTo {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    /**
     * @return BelongsTo
     */
    public function customerPharmacyInfo(): BelongsTo {
        return $this->belongsTo(CustomerPharmacyInfo::class, 'customerpharmacyinfo_id', 'id');
    }
}