<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CustomProductList_WebUser extends WebModel
{
    protected $table = 'CustomProductList_WebUser';
    protected $fillable = ['customproductlist_id', 'webuser_id', 'is_editable'];

    /**
     * @return BelongsTo
     */
    public function customProductList(): BelongsTo {
        return $this->belongsTo(CustomProductList::class, "customproductlist_id", "id");
    }

    /**
     * @return BelongsTo
     */
    public function webUser(): BelongsTo {
        return $this->belongsTo(WebUser::class, "webuser_id", "id");
    }

}