<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 4/2/19
 * Time: 10:19 AM
 */

namespace Hilco\Models;

use Flynsarmy\DbBladeCompiler\Facades\DbView;
use Illuminate\Database\Eloquent\Model;
use Hilco\Models\WebModelTranslation;
use Illuminate\Support\Arr;

/**
 * Trait HasMetadata
 * @package Hilco\Models
 */
trait HasMetadata {
    public function metadata() {
        return $this->morphMany(WebMetadata::class, 'metadatable');
    }

    public function getMetadata($name) {
        return Arr::get($this->metadata->where('meta_name', $name)->first(), 'meta_value', '');
    }

    public function setMetadata($name, $value) {
        $metadata = $this->metadata()->where('meta_name', $name)->first();

        if (strlen($value)) {
            if (is_null($metadata)) {
                $this->metadata()->updateOrCreate([
                    'meta_name' => $name,
                    'meta_value' => $value,
                ]);
            } else {
                $metadata->meta_value = $value;
                $metadata->save();
            }
        } else {
            if (!is_null($metadata)) {
                $metadata->delete();
            }
        }
    }

    public function getMetadataDescriptionAttribute() {
        return $this->getMetadata('description');
    }

    public function getMetadataTitleAttribute() {
        return $this->getMetadata('title');
    }

    /* Product hierarchy models should override the getMetadataDescriptionAttribute and getMetadataTitleAttribute
     * functions so that they default to the product name/detail or whatever.
     * The override functions are so you can still access the defined metadata value
     */
    public function getMetadataDescriptionOverrideAttribute() {
        return $this->getMetadata('description');
    }

    public function getMetadataTitleOverrideAttribute() {
        return $this->getMetadata('title');
    }

    public function setMetadataDescriptionAttribute($value) {
        $this->setMetadata('description', $value);
    }

    public function setMetadataTitleAttribute($value) {
        $this->setMetadata('title', $value);
    }
}