@if(isset($mode) && $mode === 'view')
    <div class="row container center-block">
        @foreach ($tiles as $tile)
            <div class="col-tn-12 col-xs-8 col-xs-offset-2 @if(!isset($tile['tileSize'])) col-sm-4  @else col-sm-{{$tile['tileSize']}} @endif col-sm-offset-0">
                @if($tile['component'] != null)
                    @include($tile['component'], $tile['data'])
                @endif
                <div class="visible-tn visible-xs">
                    <br>
                </div>
            </div>
        @endforeach
        <div class="clearfix" style="margin-bottom: 20px"></div>
    </div>
@else
    <div class="view-container {{$default? 'default visible' : 'alternate hidden'}}" data-view-id="{{$viewId}}" data-target-customers="@if(isset($targetCustomers))  {{ json_encode($targetCustomers) }} @endif" data-default-visibility="@if(isset($defaultVisibility) && trim($defaultVisibility) != "")  {{ $defaultVisibility }} @else Visible @endif">
        <div class="row component-tiles-container">
            @foreach($tiles as $tileId => $tile)
                <div data-tile-id="{{ $tileId }}"
                     @if( $tile['tileSize'] !== null) data-tile-size="{{ $tile['tileSize']}}" @else data-tile-size="12" @endif
                     class="component-tile-container col-sm-12 col-md-4">

                    <div id="component-area-{{ $tileId }}" class="component-area">
                        @if(isset($tile['component']))
                            @include($tile['component'], $tile['data'])
                        @endif
                    </div>

                    <button class="btn btn-primary select-component-button" data-linked-component="#component-area-{{ $tileId }}">Select a Component</button>
                </div>
            @endforeach
        </div>
        <div class="row">
            <h4 class="current-component-layout" @if($selectedLayout !== null) data-current-layout="{{ $selectedLayout }}" @else data-current-layout="full" @endif
                @if($displayName !== null) data-display-name="{{ $displayName }}" @else data-display-name="100%" @endif>
                @if($displayName !== null ) Current Layout: {{ $displayName }} @else Current Layout: 100% @endif</h4>
            <button id="changeLayout2" class="btn btn-info">Change Layout</button>
            @if($default)
                <span class='visibility-options' title="@lang('hilco::app.default_visibility_description')">@lang('hilco::app.default_visibility_colon')</span> <a href="#" class="view-defaultvisibility">@if(isset($defaultVisibility) && trim($defaultVisibility) != "") {{ $defaultVisibility }} @else Visible  @endif</a><br>
                <a class="delete-view-button btn btn-danger hidden" title="@lang('hilco::app.delete_alternate_description')" href="#">@lang('hilco::app.delete_alternate')</a>
            @else
                <span class='visibility-options' title="@lang('hilco::app.target_customers_description')">@lang('hilco::app.target_customers_colon')</span> <a href="#" class="view-targetcustomers">@if(isset($targetCustomersFormatted) && trim($targetCustomersFormatted) != "") {{ $targetCustomersFormatted }} @else None  @endif</a><br>
                <a class="delete-alternate-button btn btn-danger" title="@lang('hilco::app.delete_alternate_description')" href="#">@lang('hilco::app.delete_alternate')</a>
            @endif
        </div>
    </div>
@endif
