<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Model;

class SearchBucketStatic_WebAttributeValue extends Model
{
	use \Hilco\SoftDeletes;

	const CREATED_AT = 'date_created';
	const UPDATED_AT = 'date_modified';

	protected $table = 'SearchBucketStatic_WebAttributeValue';
	protected $fillable = ['searchbucket_id', 'webattributevalue_id'];

    public function webAttributeValue() {
        return $this->belongsTo(WebAttribute_WebPart::class, 'webattributevalue_id', 'id');
    }

    public function searchBucketStatic() {
        return $this->belongsTo(SearchBucketStatic::class, 'searchbucket_id', 'id');
    }
}
