@if($edit)
    <div class="mceNonEditable component-container" data-component-key="userInfo">
    <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('app.user_dashboard')</h4>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('userInfo', {
            menuText: '@lang('app.user_dashboard')',
            bladeTemplate: 'hilco::components.userInfo',
            init: function (body) {

            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    @if(canUser('b2b-orders'))
        <div class="col-md-4">
            <div class="panel panel-default"  style="height: 300px;">
                <div class="panel-heading">
                    <h3 class="panel-title">
                        <a href="{{ route('orders.list') }}" class="pull-right">@lang('app.see_all')</a>
                        @lang('app.recent_orders')
                    </h3>
                </div>
                <div class="panel-body" style="height: 260px; overflow-y: auto;">
                    @foreach(b2b()->activeCustomer()->recentOrders(4)->groupBy('order_date') as $orderDate => $orders)
                        <div class="row">
                            <div class="col-md-12 h4 nomargin">
                                {{ date(b2b()->dateFormatString(), strtotime($orderDate)) }}
                            </div>
                        </div>
                        @foreach($orders as $order)
                            <div class="row">
                                <div class="col-md-12">
                                    <div style="padding-left: 10px">
                                        <a href="{{ route('orders.details', [$order->hilco_order_number]) }}">{{ $order->hilco_order_number }}</a>
                                        @if(b2b()->activeWebSilo()->display_order_status)
                                        ({{ $order->friendly_order_status }})
                                        @endif
                                        - {{ $order->total_quantity }} {{ $order->total_quantity > 1 ? trans('app.item') : trans('app.items') }}
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        <hr style="margin: 5px;">
                    @endforeach
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="panel panel-default"  style="height: 300px;">
            <div class="panel-heading">
                    <h3 class="panel-title">
                        <a href="{{ route('orders.reorder') }}" class="pull-right">@lang('app.see_all')</a>
                        @lang('app.reorder_frequently_ordered_items')
                    </h3>
                </div>
                <div class="panel-body">
                    <div id="favorites-carousel" class="owl-carousel owl-theme">
                        @foreach(b2b()->activeCustomer()->topPurchasedItems() as $family)
                            @include('partials.family-block', ['family' => $family, 'captionClass' => 'h4', 'containerStyle' => 'display: none;'])
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    @if(\Route::has('orders.orderHistoryDataTable'))
    <script type="text/javascript">
            $(document).ready(function () {
                var favoriteItemsCarousel = $('#favorites-carousel');
                favoriteItemsCarousel.on({
                    'initialized.owl.carousel': function() {
                        favoriteItemsCarousel.find('.family-block-item').show();
                    }
                }).owlCarousel({
                    autoplay: true,
                    autoplayTimeout: 5000,
                    loop: true,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        320: {
                            items: 1
                        },
                        480: {
                            items: 1,
                        },
                        768: {
                            items: 2,
                        },
                        992: {
                            items: 2,
                        },
                        1440: {
                            items: 2,
                        },
                    },
                });
            });
        </script>
    @endif
    @endif
@endif
