@if($edit)
    <div class="mceNonEditable component-container" data-component-key="promoTiles">
<a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.promo_tiles')</h4>
        <div class="row">
            @foreach($tiles as $tileId => $tile)
                <div data-tile-id="{{ $tileId }}" data-link-type="{{ $tile['link']['type'] }}" data-link-target="{{ $tile['link']['target'] }}" data-web-asset-id="{{ $tile['webAssetId'] }}" class="tile-container col-xs-4">
                    <img class="tile-thumbnail center-block img-responsive" src="{{ webAssetUrl($tile['webAssetId']) }}">
                    @lang('hilco::app.destination_colon') <a href="#" class="tile-link">{!! strlen(webLinkTitle($tile['link'])) ? webLinkTitle($tile['link']) : '<em>None</em>'  !!}</a>
                </div>
            @endforeach
        </div>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('promoTiles', {
            menuText: '@lang('hilco::app.promo_tiles')',
            bladeTemplate: 'hilco::components.promoTiles',
            init: function (body) {
                $(body).on('click', '.tile-thumbnail', function () {
                    var tile = $(this).closest('.tile-container');
                    assets.finder({
                        successFunction: function (data) {
                            $(tile).attr('data-web-asset-id', data.id).find('img').attr('src', data.url);
                        }
                    });
                });
                $(body).on('click', '.tile-link', function () {
                    var tile = $(this).closest('.tile-container');
                    assets.link({
                        successFunction: function (data) {
                            $(tile).attr('data-link-type', data.link_type);
                            $(tile).attr('data-link-target', data.target);
                            $(tile).find('.tile-link').text(data.description);
                        }
                    });
                });
            },
            serialize: function (componentNode) {
                var data = {
                    tiles: {},
                };
                $(componentNode).find('.tile-container').each(function () {
                    var tileId = $(this).data('tile-id');
                    data.tiles[tileId] = {
                        webAssetId: $(this).data('web-asset-id'),
                        link: {
                            type: $(this).data('link-type'),
                            target: $(this).data('link-target'),
                        },
                    };
                });
                return data;
            },
        });
    </script>
@endif

@if($view)
    <div class="row container center-block">
        @foreach ($tiles as $tile)
        <div class="col-tn-12 col-xs-8 col-xs-offset-2 col-sm-4 col-sm-offset-0">
            <a href="{{ webLinkUrl($tile['link']) }}">
                <img class="img-responsive center-block" src="{{ webAssetUrl($tile['webAssetId']) }}/450" alt="">
            </a>
            <div class="visible-tn visible-xs">
                <br>
            </div>
        </div>
        @endforeach
        <div class="clearfix" style="margin-bottom: 20px"></div>
    </div>
@endif
