@if($edit)
    @if($wrap) <div class="mceNonEditable component-container" data-component-key="promoTiles"> @endif
        <h4>Promo Tiles</h4>
        <div class="row">
            @foreach($tiles as $tileId => $tile)
                <div data-tile-id="{{ $tileId }}" data-url="{{ $tile['url'] }}" data-web-asset-id="{{ $tile['webAssetId'] }}" class="tile-container col-md-4">
                    <img class="center-block img-responsive" src="{{ webAssetUrl($tile['webAssetId']) }}">
                    <br>
                    <div class="tile-url">{{ $tile['url'] }}</div>
                    <a class="edit-tile-button btn btn-primary" href="#">Edit Tile</a>
                    <a class="edit-tile-url-button btn btn-primary" href="#">Edit Url</a>
                </div>
            @endforeach
        </div>
    @if($wrap) </div> @endif
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('promoTiles', {
            menuText: 'Promo Tiles',
            bladeTemplate: 'hilco::components.promoTiles',
            init: function (body) {
                $(body).on('click', 'a.edit-tile-button', function () {
                    var tile = $(this).closest('.tile-container');
                    assets.finder({
                        successFunction: function (data) {
                            $(tile).attr('data-web-asset-id', data.id).find('img').attr('src', data.url);
                        }
                    });
                });
                $(body).on('click', 'a.edit-tile-url-button', function () {
                    var tile = $(this).closest('.tile-container');
                    assets.link({
                        successFunction: function (url) {
                            $(tile).attr('data-url', url);
                            $(tile).find('.tile-url').text(url);
                        }
                    });
                });
            },
            serialize: function (componentNode) {
                var data = {
                    tiles: {},
                };
                $(componentNode).find('.tile-container').each(function () {
                    var tileId = $(this).data('tile-id');
                    data.tiles[tileId] = {
                        webAssetId: $(this).data('web-asset-id'),
                        url: $(this).data('url'),
                    };
                });
                return data;
            },
        });
    </script>
@endif

@if($view)
    <div class="row container center-block">
        @foreach ($tiles as $tile)
        <div class="col-md-4">
            <a href="{{ $tile['url'] }}">
                <img class="img-responsive center-block" src="{{ webAssetUrl($tile['webAssetId']) }}" alt="">
            </a>
        </div>
        @endforeach
        <div class="clearfix" style="margin-bottom: 20px"></div>
    </div>
@endif
