<?php

use Hilco\Models\M3DiscountCode;
use Hilco\Models\PriceListSchema;
use Hilco\Models\SubscriptionGroup;

class AutoshipCart extends Cart {
    private string $autoshipHexId;

    public function __construct (SubscriptionGroup $autoship) {
        parent::__construct($autoship->soldToCustomer, $autoship->billToCustomer, $autoship->customerShippingAddress);
        $this->autoshipHexId = bin2hex($autoship->id);

        $pricelistConnection = PriceListSchema::getActivePriceListSchema()->getPriceListConnection();
        $autoshipCartLines = [];
        $m3DiscountCodes = M3DiscountCode::all()->pluck('discount_type', 'discount_code')->toArray();

        foreach ($autoship->subscriptionItems as $subscriptionItem) {
            $autoshipCartLine = new AutoshipCartLine($subscriptionItem);
            $autoshipCartLine->updatePrices(
                $pricelistConnection,
                $autoship->soldToCustomer,
                $subscriptionItem->part,
                $autoship->soldToCustomer->customerSegment,
                $m3DiscountCodes
            );
            $autoshipCartLines[] = $autoshipCartLine;
        }
        $this->setCartLines($autoshipCartLines);
    }
}