<?php

namespace Hilco\Models;


class PromotionFreeItemAction extends PromotionActionDetails {
    protected $table = 'PromotionFreeItemActions';
    protected $fillable = ['any_product','num_free','excluded','commit_sequence'];
    protected $with = ['webGroups','webCategories','webCollections','webFamilies','webParts'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'action',
            'PromotionActions', 'action_id', 'promotion_id');
    }

    public function webGroups() {
        return $this
            ->morphedByMany(WebGroup::class, 'product',
                'PromotionFreeItemAction_Product', 'promotionfreeitemaction_id')
            ->withPivot(['excluded'])
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function webCategories() {
        return $this
            ->morphedByMany(WebCategory::class, 'product',
                'PromotionFreeItemAction_Product', 'promotionfreeitemaction_id')
            ->withPivot(['excluded'])
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function webCollections() {
        return $this
            ->morphedByMany(WebCollection::class, 'product',
                'PromotionFreeItemAction_Product', 'promotionfreeitemaction_id')
            ->withPivot(['excluded'])
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function webFamilies() {
        return $this
            ->morphedByMany(WebFamily::class, 'product',
                'PromotionFreeItemAction_Product', 'promotionfreeitemaction_id')
            ->withPivot(['excluded'])
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function webParts() {
        return $this
            ->morphedByMany(WebPart::class, 'product',
                'PromotionFreeItemAction_Product', 'promotionfreeitemaction_id')
            ->withPivot(['excluded'])
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function getRelationForProductTableType($tableType) {
        if($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isApplicable(Part $part) {
        if ($this->any_product) return true;

        $freeItemActionProducts = PromotionFreeItemAction_Product::where('promotionfreeitemaction_id', '=', $this->id);
        if (!$freeItemActionProducts)
            return true;

        $validWebGroupIds = $this->webGroups->pluck('id')->toArray();
        $validWebCategoryIds = $this->webCategories->pluck('id')->toArray();
        $validWebCollectionIds = $this->webCollections->pluck('id')->toArray();
        $validWebFamilyIds = $this->webFamilies->pluck('id')->toArray();
        $validWebPartIds = $this->webParts->pluck('id')->toArray();

        $webPart = \Illuminate\Support\Arr::get($part, 'webPart');
        if (count($validWebPartIds) && in_array($webPart->id, $validWebPartIds))
            return true;

        $webFamily = \Illuminate\Support\Arr::get($webPart, 'webFamily');
        if (count($validWebFamilyIds) && in_array($webFamily->id, $validWebFamilyIds))
            return true;

        foreach (\Illuminate\Support\Arr::get($webFamily, 'webCollections', []) as $webCollection) {
            if (count($validWebCollectionIds) && in_array($webCollection->id, $validWebCollectionIds))
                return true;

            foreach (\Illuminate\Support\Arr::get($webCollection, 'webCategories', []) as $webCategory) {
                if (count($validWebCategoryIds) && in_array($webCategory->id, $validWebCategoryIds))
                    return true;

                foreach (\Illuminate\Support\Arr::get($webCategory, 'webGroups', []) as $webGroup) {
                    if (count($validWebGroupIds) && in_array($webGroup->id, $validWebGroupIds))
                        return true;
                }
            }
        }

        return false;
    }

    public function takeAction(Customer $soldToCustomer, $webCartItems, &$status)
    {
        // TODO: Implement takeAction() method.
    }

    public static function boot() {
        parent::boot();

        static::deleted(function (PromotionFreeItemAction $promotionFreeItemAction) {
            $promotionFreeItemActionProducts =
                PromotionFreeItemAction_Product::where('promotionfreeitemaction_id', '=', $promotionFreeItemAction->id);
            foreach ($promotionFreeItemActionProducts as $promotionFreeItemActionProduct) {
                $promotionFreeItemActionProduct->delete();
            }
        });
    }
}