<?php

namespace Hilco\Models;

use DB;

/**
 * Hilco\Models\FormFields
 *
 * @property integer $id
 * @property string $label
 * @property string $type
 * @property string $date_modified
 * @property string $deleted_at
 */
class FormFields extends WebModel
{
    protected $table = "FormFields";
    protected $fillable = ['label','type'];
    public static $types = [
        'text'       => 'Text Field',
        'text_label' => 'Text Label',
        'select'     => 'SelectBox',
        'checkbox'   => 'Check Box',
        'radio'      => 'Radio Button',
    ];

    public function webForms() {
        return $this->belongsToMany(WebForms::class, 'WebForm_FormField', 'formfield_id', 'webform_id');
    }

    public function values() {
        return $this->hasMany(FormFieldValues::class, 'formfield_id', 'id');  
    }

    public function attributes() {
        return $this->hasMany(FormFieldsAttributes::class, 'formfield_id', 'id');
    }

}
