<?php
namespace Hilco\Models;


class PromotionItemQuantityTrigger extends PromotionTriggerDetails {
    protected $table = 'PromotionItemQuantityTriggers';
    protected $fillable = ['minimum_quantity', 'any_product', 'almost_qualified', 'commit_sequence'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'trigger',
                                    'PromotionTriggers', 'promotion_id',
                            'promotionitemquantitytrigger_id');
    }

    public function hasAlmostQualifyingField() {
        return true;
    }

    public function webGroups() {
        return $this
            ->morphedByMany(WebGroup::class, 'product',
                'PromotionItemQuantityTrigger_Product', 'promotionitemquantitytrigger_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemQuantityTrigger_Product.deleted_at')
            ;
    }

    public function webCategories() {
        return $this
            ->morphedByMany(WebCategory::class, 'product',
                'PromotionItemQuantityTrigger_Product', 'promotionitemquantitytrigger_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemQuantityTrigger_Product.deleted_at')
            ;
    }

    public function webCollections() {
        return $this
            ->morphedByMany(WebCollection::class, 'product',
                'PromotionItemQuantityTrigger_Product', 'promotionitemquantitytrigger_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemQuantityTrigger_Product.deleted_at')
            ;
    }

    public function webFamilies() {
        return $this
            ->morphedByMany(WebFamily::class, 'product',
                'PromotionItemQuantityTrigger_Product', 'promotionitemquantitytrigger_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemQuantityTrigger_Product.deleted_at')
            ;
    }

    public function webParts() {
        return $this
            ->morphedByMany(WebPart::class, 'product',
                'PromotionItemQuantityTrigger_Product', 'promotionitemquantitytrigger_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemQuantityTrigger_Product.deleted_at')
            ;
    }

    public function getRelationForProductTableType($tableType) {
        if($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems, $distinctPartInfo = [])
    {
        $totalPartQuantity = $this->getCurrentQualifyingCartTotal($soldToCustomer, $webCartItems, $distinctPartInfo);

        return $totalPartQuantity >= $this->minimum_quantity;
    }

    public function isTriggeredPostOrder(Order $order, $lineInfo)
    {
        $totalPartQuantity = $this->getCurrentQualifyingCartTotal($order->soldToCustomer, null, [], $lineInfo);

        return $totalPartQuantity >= $this->minimum_quantity;
    }

    public function isAlmostQualifying(Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        $almostQualifyingCount = $this->getCurrentQualifyingCartTotal($soldToCustomer, $webCartItems, $distinctPartInfo);
        return ($almostQualifyingCount >= $this->almost_qualified) ?
                    $this->minimum_quantity - $almostQualifyingCount : -1;
    }

    public function getCurrentQualifyingCartTotal(Customer $soldToCustomer, $webCartItems = null, $distinctPartInfo = [], $lineInfo = null) {
        $totalPartQuantity = 0;

        if (!$this->any_product) {
            $relevantGroups = $this->webGroups;
            $relevantCategories = $this->webCategories;
            $relevantCollections = $this->webCollections;
            $relevantFamilies = $this->webFamilies;
            $relevantParts = $this->webParts;

            if(is_null($webCartItems)){
                foreach ($lineInfo as $line) {
                    $part = Part::find($line['partId']);
                    $webPart = $part->webPart;
                    $webProductPaths = $webPart->hierarchyPaths;

                    if ((count($relevantParts) > 0 && $relevantParts->contains($webPart)) ||
                        (count($relevantFamilies) > 0 && $relevantFamilies->contains($webPart->webFamily)) ||
                        $this->isValidCartItem($webProductPaths, $relevantGroups, 'webGroup') ||
                        $this->isValidCartItem($webProductPaths, $relevantCategories, 'webCategory') ||
                        $this->isValidCartItem($webProductPaths, $relevantCollections, 'webCollection')) {

                        $totalPartQuantity = $totalPartQuantity + $line['quantity'];

                    }
                }
            }else {
                foreach ($webCartItems as $webCartItem) {
                    $webPart = $webCartItem->webPart;
                    $webProductPaths = $webPart->hierarchyPaths;

                    if ((count($relevantParts) > 0 && $relevantParts->contains($webPart)) ||
                        (count($relevantFamilies) > 0 && $relevantFamilies->contains($webPart->webFamily)) ||
                        $this->isValidCartItem($webProductPaths, $relevantGroups, 'webGroup') ||
                        $this->isValidCartItem($webProductPaths, $relevantCategories, 'webCategory') ||
                        $this->isValidCartItem($webProductPaths, $relevantCollections, 'webCollection')) {

                        $totalPartQuantity = $totalPartQuantity + $webCartItem->quantity;

                    }
                }
            }
        } else {
            if(is_null($webCartItems)) {
                foreach ($lineInfo as $line) {
                    $totalPartQuantity = $totalPartQuantity + $line['quantity'];
                }
            }else {
                foreach ($webCartItems as $webCartItem) {
                    $totalPartQuantity = $totalPartQuantity + $webCartItem->quantity;
                }
            }
        }

        return $totalPartQuantity;
    }

    public function setMinimumQuantityAttribute($value) {
        $this->attributes['minimum_quantity'] = $value;
    }

    public function setAnyProductAttribute($value) {
        $this->attributes['any_product'] = $value;
    }

    public function postTriggerOperation($soldToCustomer){}

    private function isValidCartItem($webProductPaths, $relevantProducts, $productType) {
        if ($this->any_product) return true;
        foreach ($webProductPaths as $webProductPath) {
            if ($relevantProducts->contains($webProductPath[$productType])) {
                return true;
            }
        }
        return false;
    }

    public static function boot() {
        parent::boot();

        static::deleted(function (PromotionItemQuantityTrigger $promotionItemQuantityTrigger) {
            $promotionItemQuantityTriggerProducts =
                PromotionItemQuantityTrigger_Product::where('promotionitemquantitytrigger_id', '=', $promotionItemQuantityTrigger->id)->get();
            foreach ($promotionItemQuantityTriggerProducts as $promotionItemQuantityTriggerProduct) {
                $promotionItemQuantityTriggerProduct->delete();
            }
        });
    }
}