<?php
/**
 * Created by PhpStorm.
 * User: jmartinez
 * Date: 5/1/2017
 * Time: 10:33 AM
 */

namespace Hilco\Models;
use DB;

class PromotionCustomerCategoryTrigger extends PromotionTriggerDetails {
    protected $table = 'PromotionCustomerCategoryTriggers';

    public function customerCategories() {
        return $this->belongsToMany(CustomerCategory::class, 'PromotionCustomerCategoryTrigger_CustomerCategory', 'promotioncustomercategorytrigger_id', 'customercategory_id')
                    ->wherePivot('deleted_at', '=', DB::raw(0))
                    ->withPivot(['excluded']);
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        $soldToCustomerCategory = $soldToCustomer->customerCategory;
        return !is_null($this->customerCategories()->where('customercategory_id', $soldToCustomerCategory->id)->first());
    }

    public function isTriggeredPostOrder(Order $order, $lineInfo)
    {
        return true;
    }

    public function postTriggerOperation($soldToCustomer)
    {
        // TODO: Implement postTriggerOperation() method.
    }
}